IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[CD_CTR] [int] NOT NULL,
	[DT_CAD_CONFIRMA] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO] ADD  CONSTRAINT [DF_EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO] ADD  CONSTRAINT [DF_EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO] ADD  CONSTRAINT [DF_EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO] ADD  CONSTRAINT [DF_EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO_DT_CAD]  DEFAULT ((0)) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO] ADD  CONSTRAINT [DF_EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO] ADD  CONSTRAINT [DF_EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO_DT_CAD_CONFIRMA]  DEFAULT (getdate()) FOR [DT_CAD_CONFIRMA]

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO_EST_NF_ENT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_ENT] ([CD_EMP], [CD_FILIAL], [CD_NF])

ALTER TABLE [dbo].[EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO] CHECK CONSTRAINT [FK_EST_NF_ENT_FISCAL_CONFIRMACAO_RECBTO_EST_NF_ENT]
end
